/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.UserRole;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UserRolePermissionsSet {
    private static Set allUserRoles;
    private Set permittedRoles = new HashSet();

    public UserRolePermissionsSet(ObjectId objId) {
        this(objId, UserRolePermissionsSet.getAllUserRoles());
    }

    public UserRolePermissionsSet(ObjectId objId, Set userRoles) {
        UserRole role = null;
        Iterator iterator = userRoles.iterator();
        while (iterator.hasNext()) {
            role = (UserRole)iterator.next();
            if (!role.isObjectPermitted(objId)) continue;
            this.permittedRoles.add(role);
        }
    }

    public Set getPermittedRoles() {
        return this.permittedRoles;
    }

    public boolean isPermitted(Set userRoles) {
        Iterator iterator = userRoles.iterator();
        while (iterator.hasNext()) {
            if (!this.permittedRoles.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static Set getAllUserRoles() {
        if (allUserRoles == null) {
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            allUserRoles = mom.getInventory(new ClassId("com.ibm.hwmca.fw.managed", "UserRole"));
        }
        return allUserRoles;
    }
}

